<?php

use App\Http\Middleware\AuthenticateMiddleware;
use Illuminate\Support\Facades\Route;

Route::post(
    "/admin-session",
    [
        "uses" => "AdminSession\\AdminSessionController@index"
    ]
);
Route::get(
    '/admin/{IdAdmin}',
    [
        "uses" => "Admin\\AdminIdController@index"
    ]
)->where('IdAdmin', '[0-9]*')
    ->middleware(AuthenticateMiddleware::class);

Route::post(
    "/admin",
    [
        "uses" => "Admin\\AdminCreateController@index"
    ]
)->middleware(AuthenticateMiddleware::class);


Route::get(
    "/admin",
    [
        "uses" => "Admin\\AdminListController@index"
    ]
)->middleware(AuthenticateMiddleware::class);
Route::delete(
    '/admin/{IdAdmin}',
    [
        "uses" => "Admin\\AdminDeleteController@index"
    ]
)->where('IdAdmin', '[0-9]*')
    ->middleware(AuthenticateMiddleware::class);
Route::put(
    '/admin/{IdAdmin}',
    [
        "uses" => "Admin\\AdminUpdateController@index"
    ]
)->where('IdAdmin', '[0-9]*')
    ->middleware(AuthenticateMiddleware::class);
