<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Symfony\Component\Console\Helper\Table;

class Advisor extends Model
{
    public $timestamps = false;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'IdAdvisor',
        'NameAdvisor',
        'ImgAdvisor',
        'AverageAdvisor',
        'ActiveAdvisor'
    ];
    protected $table = "advisor";
    protected $primaryKey = 'IdAdvisor';
    public function ratings()
    {
        return $this->hasMany(Rating::class, 'IdAdvisor', 'IdAdvisor');
    }
}

