<?php

namespace App\Http\Controllers\Cliente\Rating;

use App\Models\Rating;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Fail;
use App\Models\Advisor;
use Illuminate\Support\Facades\DB;
use App\Models\Success;
use GrahamCampbell\ResultType\Result;
use App\Providers\AdvisorProvider;

class RatingCreateController
{
    public function __construct(public AdvisorProvider $advisorProvider)
    {
    }
    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ValueRating' => 'required|int',
            'IdAdvisor' => 'required|int',
        ]);

        if ($validator->fails()) {
            return json_encode(new Fail(
                success: false,
                error: $validator->errors()
            ));
        }
        $advisor = $this->advisorProvider->findAdvisor($request->input('IdAdvisor'));
        if ($advisor == null) {
            return $this->advisorProvider->findAdvisorFail();
        }
        $rating = new Rating();
        $rating->ValueRating = $request->input('ValueRating');
        $rating->DateRating = date('Y-m-d H:i:s');
        $rating->IdAdvisor = $request->input('IdAdvisor');
        $rating->save();

        $average = $this->findAverage($request->input('IdAdvisor'));
        $advisor->AverageAdvisor = $average;
        $advisor->save();

        return json_encode(
            new Success(
                true,
                "Successfully created",
                (object)[
                    "Id" => $rating->IdRating
                ]
            )
        );
    }
    public function findAverage($IdAdvisor)
    {
        $result = DB::select('SELECT SUM(`ValueRating`)/COUNT(`IdRating`) `average` FROM `rating` WHERE `IdAdvisor` = ?', [$IdAdvisor]);
        if ($result[0]->average == null) {
            return  -1;
        } else return ($result[0]->average);
    }

    public function findAverageByYear($IdAdvisor, $year)
    {
        $result = DB::select(
            'SELECT SUM(`ValueRating`)/COUNT(`IdRating`) `average` 
                          FROM `rating` 
                          WHERE `IdAdvisor` = ? 
                          AND YEAR(`DateRating`) = ?',
            [$IdAdvisor, $year]
        );

        if ($result[0]->average == null) {
            return -1;
        } else {
            return $result[0]->average;
        }
    }
    public function findAverageByMonth($IdAdvisor, $year, $month)
    {
        $result = DB::select(
            'SELECT SUM(`ValueRating`)/COUNT(`IdRating`) `average` 
                          FROM `rating` 
                          WHERE `IdAdvisor` = ? 
                          AND YEAR(`DateRating`) = ? 
                          AND MONTH(`DateRating`) = ?',
            [$IdAdvisor, $year, $month]
        );

        if ($result[0]->average == null) {
            return -1;
        } else {
            return $result[0]->average;
        }
    }
    public function findAverageByDay($IdAdvisor, $year, $month, $day)
    {
        $result = DB::select(
            'SELECT SUM(`ValueRating`)/COUNT(`IdRating`) `average` 
                          FROM `rating` 
                          WHERE `IdAdvisor` = ? 
                          AND YEAR(`DateRating`) = ? 
                          AND MONTH(`DateRating`) = ? 
                          AND DAY(`DateRating`) = ?',
            [$IdAdvisor, $year, $month, $day]
        );

        if ($result[0]->average == null) {
            return -1;
        } else {
            return $result[0]->average;
        }
    }
}
