<?php
namespace App\Http\Controllers\Admin\Session;
use App\Models\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Fail;
use Illuminate\Support\Facades\DB;
use App\Models\Success;
use GrahamCampbell\ResultType\Result;
class SessionCreateController {
    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'IdAdmin' => 'required|int',
        ]);

        if ($validator->fails()) {
            return json_encode( new Fail (
                success:false,
                error:$validator->errors()
            ));
        }
        $current_date = now(); 
        $date_24_hours = now()->addHours(24); 
        $session = new Session();
        $session->IdAdmin = $request->input('IdAdmin');
        $session->DateStartSession = $current_date;
        $session->DateEndSession = $date_24_hours;
        $session->TokenSession= bin2hex(random_bytes(32));
        $session->save();
        return json_encode(new Success(
            true,
            "Successfully created",
            (object)[
                "TokenSession"=>$session->TokenSession
            ]
            )
        );
    }
}
