<?php

namespace App\Http\Controllers\Admin\Rating;

use App\Models\Rating;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

class ExcelController
{
    public function exportExcel(Request $request)
    {
        // Lógica para generar el archivo Excel
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Establecer el título
        $sheet->setCellValue('A1', 'Reporte de Calificación');
        $sheet->mergeCells('A1:J1'); // Ajustar el rango de celdas para el título

        // Aplicar estilo al título
        $titleStyle = [
            'font' => ['bold' => true, 'size' => 16],
            'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER],
        ];
        $sheet->getStyle('A1')->applyFromArray($titleStyle);

        // Establecer las cabeceras de la tabla
        $sheet->setCellValue('A2', 'Fecha');
        $sheet->setCellValue('B2', 'Hora');
        $sheet->setCellValue('C2', 'Asesor');
        $sheet->setCellValue('D2', 'Valor');
        $sheet->setCellValue('E2', 'Calificación'); // Cabecera de combinación
        $sheet->mergeCells('E2:J2'); // Combinar las celdas de la cabecera

        // Aplicar estilos a las cabeceras
        $headerStyle = [
            'font' => ['bold' => true],
            'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER],
            'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => 'EEEEEE']],
            'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]],
        ];

        $sheet->getStyle('A2:J2')->applyFromArray($headerStyle);

        // Obtener los datos uniendo las tablas rating y advisor
        $ratings = Rating::with('advisor')->get();

        // Definir estilos para diferentes valores de calificación
        $styles = [
            1 => ['bgColor' => 'ff3b30', 'fontColor' => 'FFFFFF'], // Rojo
            2 => ['bgColor' => 'ff9500', 'fontColor' => '000000'], // Naranja
            3 => ['bgColor' => 'ffcc00', 'fontColor' => '000000'], // Amarillo
            4 => ['bgColor' => 'ced146', 'fontColor' => '000000'], // Verde Limón
            5 => ['bgColor' => '34c759', 'fontColor' => 'FFFFFF'], // Verde
        ];

        // Agregar los datos a la hoja de cálculo
        $row = 3; // Empezar en la tercera fila
        foreach ($ratings as $rating) {
            // Convertir la fecha a formato DD/MM/YYYY
            $formattedDate = date('d/m/Y', strtotime($rating->DateRating));
            // Obtener la hora
            $formattedTime = date('H:i:s', strtotime($rating->DateRating));

            $sheet->setCellValue('A' . $row, $formattedDate); // Fecha en formato DD/MM/YYYY
            $sheet->setCellValue('B' . $row, $formattedTime); // Hora
            $sheet->setCellValue('C' . $row, $rating->advisor->NameAdvisor);
            $sheet->setCellValue('D' . $row, $rating->ValueRating);

            // Aplicar estilos según el valor de la calificación
            $valueRating = $rating->ValueRating;

            if ($valueRating === 1) {
                $sheet->setCellValue("E{$row}", 1); // E columna
                $sheet->getStyle("E{$row}")->applyFromArray(['fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => $styles[1]['bgColor']]]]);
            } elseif ($valueRating === 2) {
                $sheet->setCellValue("F{$row}", 2); // F columna
                $sheet->getStyle("F{$row}")->applyFromArray(['fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => $styles[2]['bgColor']]]]);
            } elseif ($valueRating === 3) {
                $sheet->setCellValue("G{$row}", 3); // G columna
                $sheet->getStyle("G{$row}")->applyFromArray(['fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => $styles[3]['bgColor']]]]);
            } elseif ($valueRating === 4) {
                $sheet->setCellValue("H{$row}", 4); // H columna
                $sheet->getStyle("H{$row}")->applyFromArray(['fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => $styles[4]['bgColor']]]]);
            } elseif ($valueRating === 5) {
                $sheet->setCellValue("I{$row}", 5); // I columna
                $sheet->getStyle("I{$row}")->applyFromArray(['fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => $styles[5]['bgColor']]]]);
            }
            $row++;
        }

        // Ajustar el ancho de las columnas
        $sheet->getColumnDimension('A')->setWidth(12); // Fecha
        $sheet->getColumnDimension('B')->setWidth(12); // Hora
        $sheet->getColumnDimension('C')->setWidth(30); // Asesor
        $sheet->getColumnDimension('D')->setWidth(15); // Valor
        $sheet->getColumnDimension('E')->setWidth(3); // Calificación
        $sheet->getColumnDimension('F')->setWidth(3); // Calificación
        $sheet->getColumnDimension('G')->setWidth(3); // Calificación
        $sheet->getColumnDimension('H')->setWidth(3); // Calificación
        $sheet->getColumnDimension('I')->setWidth(3); // Calificación
        $sheet->getColumnDimension('J')->setWidth(3); // Calificación

        // Aplicar bordes a toda la tabla
        $sheet->getStyle("A1:J{$row}")->applyFromArray([
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);

        // Guardar el archivo en storage o en un directorio temporal
        $fileName = 'ratings.xlsx';
        $filePath = storage_path('app/' . $fileName);
        $writer = new Xlsx($spreadsheet);
        $writer->save($filePath);

        // Devolver el archivo para descargar
        return response()->download($filePath, $fileName)->deleteFileAfterSend();
    }
}