<?php
namespace App\Http\Controllers\Admin\Advisor;
use App\Models\Advisor;
use Illuminate\Support\Facades\DB;
class AdvisorOfTheMonthController
{

    public function index()
    {

        $topAdvisor = DB::table('rating')
            ->select('IdAdvisor', DB::raw('AVG(ValueRating) as average_rating'))
            ->whereBetween('DateRating', [date("Y-m-01"), date("Y-m-01", strtotime("+1 month"))])
            // ->whereBetween('DateRating', ['2024-04-01 00:00:00', '2024-04-30 23:59:59'])
            ->groupBy('IdAdvisor')
            ->orderByDesc('average_rating')
            ->limit(1)
            ->first();
            if ($topAdvisor) {
                $idAdvisor = $topAdvisor->IdAdvisor;
                $averageRating = $topAdvisor->average_rating;
                // Segunda consulta en la tabla advisor utilizando el IdAdvisor
                $advisorDetails = DB::table('advisor')
                    ->where('IdAdvisor', $idAdvisor)
                    ->first();
                if ($advisorDetails) {
                    $advisorDetails->ImgAdvisor = config('app.PUBLIC_URL') . $advisorDetails->ImgAdvisor;
                    // Aquí puedes trabajar con los detalles del advisor
                    // Por ejemplo:
                    // $advisorName = $advisorDetails->Name; // Asumiendo que hay una columna 'Name'
                    // Hacer algo con $advisorName y otros detalles
                    return json_encode ($advisorDetails);
                } else {
                    // Manejar el caso donde no se encontró el advisor
                }return json_encode ($topAdvisor);
            } else {
                // Manejar el caso donde no se encontró ningún IdAdvisor
                return json_encode(null);
            }
    }
}