<?php
namespace App\Http\Controllers\Admin\Admin;
use App\Models\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Fail;
use Illuminate\Support\Facades\DB;
use App\Models\Success;
use GrahamCampbell\ResultType\Result;
class AdminCreateController {
    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'NameAdmin' => 'required|string|max:50',
            'AccountAdmin' => 'required|string|max:50',
            'PasswordAdmin' => 'required|string|max:100',
        ]);

        if ($validator->fails()) {
            return json_encode( new Fail (
                success:false,
                error:$validator->errors()
            ));
        }

        $admin = new Admin();
        $admin->NameAdmin = $request-> input('NameAdmin');
        $admin->AccountAdmin = $request-> input('AccountAdmin');
        $admin->PasswordAdmin = sha1( $request->input('PasswordAdmin'));

        $admin->save();

        return json_encode(new Success(
            true,
            "Successfully created",
            (object)[
                "Id"=>$admin->IdAdmin
            ]
            )
        );
    }
}
