<?php

use App\Http\Middleware\AuthenticateMiddleware;
use Illuminate\Support\Facades\Route;

Route::get(
    "/advisor",
    [
        "uses" => "Advisor\\AdvisorListController@index"

    ]
)->middleware(AuthenticateMiddleware::class);
Route::post(
    "/advisor",
    [
        "uses" => "Advisor\\AdvisorCreateController@index"
    ]
)->middleware(AuthenticateMiddleware::class);
Route::delete(
    '/advisor/{IdAdvisor}',
    [
        "uses" => "Advisor\\AdvisorDeleteController@index"
    ]
)->where('IdAdvisor', '[0-9]*')->middleware(AuthenticateMiddleware::class);





Route::put(
    '/advisor/{IdAdvisor}/active',
    [
        "uses" => "Advisor\\AdvisorUpdateActiveController@index"
    ]
)->where('IdAdvisor', '[0-9]*')->middleware(AuthenticateMiddleware::class);


Route::post(
    '/advisor/{IdAdvisor}',
    [
        "uses" => "Advisor\\AdvisorUpdateController@index"
    ]
)->where('IdAdvisor', '[0-9]*')->middleware(AuthenticateMiddleware::class);

Route::post(
    "/advisor/advisorfilter",
    [
        "uses" => "Advisor\\AdvisorFilterDateController@average"
    ]
)->middleware(AuthenticateMiddleware::class);
Route::post(
    "/advisor/advisorfilterday",
    [
        "uses" => "Advisor\\AdvisorFilterDayController@average"
    ]
)->middleware(AuthenticateMiddleware::class);
Route::post(
    "/advisor/advisorfilteryear",
    [
        "uses" => "Advisor\\AdvisorFilterYearController@monthlyAverages"
    ]
)->middleware(AuthenticateMiddleware::class);
Route::get(
    "/advisor/advisorofthemonth",
    [
        "uses" => "Advisor\\AdvisorOfTheMonthController@index"
    ]
)->middleware(AuthenticateMiddleware::class);
Route::get(
    '/advisor/{IdAdvisor}',
    [
        "uses" => "Advisor\\AdvisorIdController@index"
    ]
)->where('IdAdvisor', '[0-9]*')->middleware(AuthenticateMiddleware::class);

Route::post(
    '/advisor/image',
    [
        "uses" => "Advisor\\AdvisorImageController@upload"
    ]
)->middleware(AuthenticateMiddleware::class);