<?php

namespace App\Http\Controllers\Admin\Advisor;

use App\Models\Advisor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Fail;
use Illuminate\Support\Facades\DB;
use App\Models\Success;
use GrahamCampbell\ResultType\Result;
use App\Providers\AdvisorProvider;

class AdvisorUpdateController
{
    public function __construct(public AdvisorProvider $advisorProvider)
    {
    }
    public function index(Request $request, $IdAdvisor)
    {
        $validator = Validator::make($request->all(), [
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'NameAdvisor' => 'required|string|max:50',
        ]);
        if ($validator->fails()) {
            return json_encode(new Fail(
                false,
                $validator->errors()
            ));
        }
        $advisor = $this->advisorProvider->findAdvisor($IdAdvisor);
        if ($advisor == null) {
            return $this->advisorProvider->findAdvisorFail();
        }
        // --------------------verificar, si envió imagen----
        if ($request->hasFile('image')) {
            $image = $request->file('image');  //garantiza que el nombre sea único
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path(config('app.PRIVATE_URL') . 'images/advisor'), $imageName); //la carpeta se guardará edn public/images
            $advisor->ImgAdvisor ='images/advisor/' . $imageName;
        }
        // --------------------------------------------------------------
        $advisor->NameAdvisor = $request->input('NameAdvisor');
        $advisor->save();
        return json_encode(new Success(
            true,
            "Successfully updated",
            (object)[
                "Id" => $advisor->IdAdvisor
            ]
        ));
    }
}
