<?php

namespace App\Http\Controllers\Admin\Advisor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdvisorFilterDayController
{
    public function average(Request $request)
    {
        $year = $request->input('year');
        $month = $request->input('month');
        $IdAdvisor = $request->input('IdAdvisor');

        // Validar que el ID del advisor esté presente
        if (empty($IdAdvisor)) {
            return response()->json(['error' => 'Debe proporcionar un ID de advisor'], 400);
        }

        // Obtener el advisor específico
        $advisor = DB::table('advisor')
            ->select('IdAdvisor', 'NameAdvisor')
            ->where('IdAdvisor', $IdAdvisor)
            ->first();

        // Si no se encuentra el advisor, devolver un array vacío
        if (!$advisor) {
            return response()->json(['averages' => []]);
        }

        // Calcular los promedios para el advisor en el período especificado
        $averages = $this->calculateAverage($year, $month, $IdAdvisor);

        // Si no se encontraron registros para el advisor en el período, devolver cero
        if (empty($averages)) {
            return response()->json(['averages' => []]);
        }

        return response()->json(['averages' => $averages]);
    }

    public function calculateAverage($year, $month, $IdAdvisor)
    {
        // Crear un array para almacenar los resultados
        $result = [];

        // Obtener todos los días del mes y año especificados
        $daysInMonth = Carbon::createFromDate($year, $month, 1)->daysInMonth;

        // Iterar sobre cada día del mes
        for ($day = 1; $day <= $daysInMonth; $day++) {
            $date = "{$year}-{$month}-{$day}";

            // Consulta para obtener los ratings del advisor para el día actual
            $query = DB::table('rating')
                ->where('IdAdvisor', $IdAdvisor)
                ->whereDate('DateRating', $date);

            // Calcular el promedio y contar los ratings para el día actual del advisor
            $dailyAverage = $query->select(
                DB::raw('COALESCE(avg(ValueRating), 0) as averageRating'),
                DB::raw('count(*) as ratingCount')
            )->first();

            // Crear el resultado para el día actual
            $result[] = [
                'Date' => $date,
                'averageRating' => $dailyAverage->averageRating,
                'ratingCount' => $dailyAverage->ratingCount
            ];
        }

        return $result;
    }
} 