<?php
namespace App\Http\Controllers\Admin\Advisor;
use App\Models\Advisor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Fail;
use Illuminate\Support\Facades\DB;
use App\Models\Success;
use GrahamCampbell\ResultType\Result;
class AdvisorCreateController {
    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'NameAdvisor' => 'required|string|max:50',
            'ImgAdvisor' => 'required|string|max:250',
        ]);

        if ($validator->fails()) {
            return json_encode( new Fail (
                success:false,
                error:$validator->errors()
            ));
        }

        $advisor = new Advisor();
        $advisor->NameAdvisor = $request-> input('NameAdvisor');
        $advisor->ImgAdvisor = $request-> input('ImgAdvisor');
        $advisor->AverageAdvisor = -1;
        $advisor->ActiveAdvisor = 0;
        $advisor->save();

        return json_encode(new Success(
            true,
            "Successfully created",
            (object)[
                "Id"=>$advisor->IdAdvisor
            ]
            )
        );
    }
}
